/*
 * Decompiled with CFR 0.152.
 */
package com.oxaion.tools.weblauncher.xml;

import com.oxaion.tools.weblauncher.data.Repository;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.CallSite;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;

public class FileVersionGenerator {
    private Repository repository;
    private String clientOS;
    private Map<String, File> fileMap;

    private FileVersionGenerator(Repository repository, String clientOS) {
        this.repository = repository;
        this.clientOS = clientOS;
        this.fileMap = new LinkedHashMap<String, File>();
    }

    public static String generateFileVersionList(Repository repository, String clientOS, File ... rootFolder) throws UnsupportedEncodingException {
        clientOS = clientOS == null ? "" : clientOS.toLowerCase();
        FileVersionGenerator generator = new FileVersionGenerator(repository, clientOS);
        for (File root : rootFolder) {
            generator.processFolder(root, root.toPath());
        }
        return generator.generateFileVersionList();
    }

    private String generateFileVersionList() throws UnsupportedEncodingException {
        StringBuilder xml = new StringBuilder();
        xml.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
        xml.append("<root>");
        ArrayList<String> filePaths = new ArrayList<String>(this.fileMap.keySet());
        Collections.sort(filePaths, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                String s1 = o1.toUpperCase().replace('/', '\u0000');
                String s2 = o2.toUpperCase().replace('/', '\u0000');
                return s1.compareTo(s2);
            }
        });
        Stack<CallSite> currentDir = new Stack<CallSite>();
        for (String filepath : filePaths) {
            File file = this.fileMap.get(filepath);
            while (!currentDir.isEmpty() && !filepath.startsWith((String)currentDir.peek())) {
                xml.append("</folder>");
                currentDir.pop();
            }
            if (file.isDirectory()) {
                xml.append("<folder><name>");
                xml.append(URLEncoder.encode(file.getName(), StandardCharsets.UTF_8.toString()));
                xml.append("</name>");
                currentDir.push((CallSite)((Object)(filepath + "/")));
                continue;
            }
            xml.append("<file><name>");
            xml.append(URLEncoder.encode(file.getName(), StandardCharsets.UTF_8.toString()));
            xml.append("</name><lastmodified>");
            xml.append(file.lastModified());
            xml.append("</lastmodified><size>");
            xml.append(file.length());
            xml.append("</size></file>");
        }
        while (!currentDir.isEmpty()) {
            xml.append("</folder>");
            currentDir.pop();
        }
        xml.append("</root>");
        return xml.toString();
    }

    private void processFolder(File folder, Path root) throws UnsupportedEncodingException {
        if (!this.repository.isExcluded(folder.getName(), this.clientOS)) {
            Object[] children = folder.listFiles();
            if (children == null) {
                return;
            }
            Arrays.sort(children);
            for (int i = 0; i < children.length; ++i) {
                if (((File)children[i]).isDirectory()) {
                    String path = root.relativize(((File)children[i]).toPath()).toString().replace(File.separator, "/");
                    this.fileMap.put(path, (File)children[i]);
                    this.processFolder((File)children[i], root);
                    continue;
                }
                this.processFile((File)children[i], root);
            }
        }
    }

    private void processFile(File file, Path root) throws UnsupportedEncodingException {
        if (!this.repository.isExcluded(file.getName(), this.clientOS)) {
            String path = root.relativize(file.toPath()).toString().replace(File.separator, "/");
            this.fileMap.put(path, file);
        }
    }
}

