/*
 * Decompiled with CFR 0.152.
 */
package com.oxaion.tools.weblauncher.data;

import com.oxaion.tools.weblauncher.data.OSConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.StringTokenizer;

public class Configuration {
    private String basePath;
    private String configFileName;
    private String host;
    private String language;
    private HashMap<String, OSConfiguration> osConfigurations = new HashMap();
    private int port;
    private String versionFile = "/currentversions.xml";
    private String protocol;
    private String name;
    private String arguments = "";
    private boolean fromServer;
    private String nucleusURL;
    private boolean downloaded;

    public String getBasePath() {
        return this.basePath;
    }

    public String getConfigFileName() {
        return this.configFileName;
    }

    public String getHost() {
        return this.host;
    }

    public String getHostIdentifier() {
        Object cleanedPath = this.basePath.replaceAll("[/\\\\]", "-");
        if (((String)cleanedPath).endsWith("-")) {
            cleanedPath = ((String)cleanedPath).substring(((String)cleanedPath).length() - 1);
        }
        if (!((String)cleanedPath).startsWith("-")) {
            cleanedPath = "-" + (String)cleanedPath;
        }
        return this.host + (String)(this.port == 80 ? "" : "-" + this.port) + (String)cleanedPath;
    }

    public String getLanguage() {
        return this.language;
    }

    public OSConfiguration getOSConfiguration(String os, boolean parse) {
        ArrayList<String> osWordsList = new ArrayList<String>();
        StringBuilder wordsBuilder = new StringBuilder(4);
        os = os.toUpperCase();
        StringTokenizer st = new StringTokenizer(os, " .");
        while (st.hasMoreTokens()) {
            if (wordsBuilder.length() > 0) {
                wordsBuilder.append(" ");
            }
            wordsBuilder.append(st.nextToken());
            osWordsList.add(wordsBuilder.toString());
        }
        Collections.reverse(osWordsList);
        osWordsList.add("");
        if (parse && !this.osConfigurations.containsKey(osWordsList.get(0))) {
            this.osConfigurations.put((String)osWordsList.get(0), new OSConfiguration());
        }
        OSConfiguration retVal = null;
        for (String osWords : osWordsList) {
            retVal = this.osConfigurations.get(osWords);
            if (retVal == null) continue;
            return retVal;
        }
        return null;
    }

    public int getPort() {
        return this.port;
    }

    public String getUniqueIdentifier() {
        return String.valueOf((this.configFileName + this.basePath + this.host + this.port).hashCode());
    }

    public String getVersionFile() {
        return this.versionFile;
    }

    public void setBasePath(String string) {
        this.basePath = string;
    }

    public void setConfigFileName(String string) {
        this.configFileName = string;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public void setLanguage(String string) {
        this.language = string;
    }

    public void setPort(int i) {
        this.port = i;
    }

    public void setVersionFile(String string) {
        this.versionFile = string;
    }

    public void clearOSConfigurations() {
        this.osConfigurations.clear();
    }

    public Collection<OSConfiguration> getOSConfigurations() {
        return this.osConfigurations.values();
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getSortName() {
        return this.name + " - " + this.host + this.port;
    }

    public void setArguments(String s) {
        this.arguments = s;
    }

    public String getArguments() {
        return this.arguments;
    }

    public void setNucleusUrl(String string) {
        this.nucleusURL = string;
    }

    public String getNucleusURL() {
        return this.nucleusURL;
    }

    public void setDownloaded(boolean b) {
        this.downloaded = b;
    }

    public boolean isDownloaded() {
        return this.downloaded;
    }

    public boolean isFromServer() {
        return this.fromServer;
    }

    public void setFromServer(boolean b) {
        this.fromServer = b;
    }
}

