/*
 * Decompiled with CFR 0.152.
 */
package com.oxaion.tools.weblauncher;

import com.oxaion.tools.weblauncher.LauncherWindow;
import com.oxaion.tools.weblauncher.Main;
import com.oxaion.tools.weblauncher.UpdateTask;
import com.oxaion.tools.weblauncher.data.Configuration;
import com.oxaion.tools.weblauncher.data.File;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Taskbar;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.table.DefaultTableCellRenderer;

public class Manager
implements LauncherWindow {
    private static final boolean WINDOWS = System.getProperty("os.name").startsWith("Windows");
    private JFrame frame;
    private JPanel main;
    private JLabel progress;
    private String rootDirectory;
    private List<Configuration> configurations = new ArrayList<Configuration>();
    private ImageIcon startLogo;
    private ImageIcon editLogo;
    private ImageIcon deleteLogo;
    private ImageIcon nucleusLogo;
    private ImageIcon busyLogo;
    private String search = "";
    private JTextField searchField;
    private EditDialog edit;
    private boolean viewLocal = true;
    private long value;

    public static void main(String[] args) {
        if (args.length > 0) {
            Main.main(args);
            return;
        }
        if (WINDOWS) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        new Manager();
    }

    public Manager() {
        this.detectOperatingSystem();
        this.readManagerUrl();
        this.readManagerFile();
        this.readDirectory();
        this.frame = new JFrame("oxaion Manager");
        this.frame.setIconImage(new ImageIcon(this.getClass().getResource("logo-crossfeed.png")).getImage());
        this.frame.setDefaultCloseOperation(3);
        this.frame.setLayout(new BorderLayout());
        this.createHeaderArea();
        this.createMainArea();
        this.createFooterArea();
        this.startLogo = new ImageIcon(this.getClass().getResource("button_green_play.png"));
        this.editLogo = new ImageIcon(this.getClass().getResource("design.png"));
        this.deleteLogo = new ImageIcon(this.getClass().getResource("trash_bin.png"));
        this.busyLogo = new ImageIcon(this.getClass().getResource("link_network_green_green.png"));
        this.nucleusLogo = new ImageIcon(this.getClass().getResource("internet.png"));
        this.frame.pack();
        this.reload();
        this.searchField.requestFocus();
        this.frame.setLocationRelativeTo(null);
        this.frame.setVisible(true);
        this.edit = new EditDialog();
        this.frame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                for (int i = 0; i < Manager.this.main.getComponentCount(); ++i) {
                    Manager.this.setPanelSize((JPanel)Manager.this.main.getComponent(i));
                }
            }
        });
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                Manager.this.searchField.requestFocusInWindow();
            }
        });
    }

    public void debugSystemProperties() {
        try {
            PrintWriter p = new PrintWriter("/Users/mschober/test.txt");
            for (Object object : System.getProperties().keySet()) {
                p.println(object + " = " + System.getProperty(object.toString()));
            }
            p.println("------------");
            for (String string : System.getenv().keySet()) {
                p.println(string + " = " + System.getenv(string));
            }
            p.close();
            JOptionPane.showMessageDialog(null, new java.io.File(System.getProperty("user.dir")).getCanonicalPath());
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public void createFooterArea() {
        this.progress = new JLabel();
        this.progress.setBorder(BorderFactory.createEmptyBorder(2, 10, 3, 0));
        this.progress.setPreferredSize(new Dimension(10, 30));
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.progress, "Center");
        JRadioButton local = new JRadioButton("Lokal", true);
        JRadioButton remote = new JRadioButton("Remote");
        local.addActionListener(e -> this.toggleViewLocal());
        remote.addActionListener(e -> this.toggleViewLocal());
        ButtonGroup group = new ButtonGroup();
        group.add(local);
        group.add(remote);
        JPanel radios = new JPanel();
        radios.add(local);
        radios.add(remote);
        panel.add((Component)radios, "East");
        this.frame.add((Component)panel, "South");
    }

    private void toggleViewLocal() {
        this.viewLocal = !this.viewLocal;
        this.reload();
    }

    public void createHeaderArea() {
        JButton add = new JButton("+");
        add.addActionListener(e -> {
            if ((e.getModifiers() & 8) == 8) {
                try {
                    Desktop.getDesktop().open(new java.io.File(this.rootDirectory));
                }
                catch (IOException e1) {
                    this.reportError("Verzeichnis kann nicht ge\u00f6ffnet werden", e1);
                }
            } else {
                this.edit.newConfig();
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)add, "Center");
        if (WINDOWS) {
            panel.setBorder(BorderFactory.createEmptyBorder(0, 7, 0, 10));
        }
        JPanel header = new JPanel();
        header.setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 20));
        header.setLayout(new BorderLayout());
        header.add((Component)panel, "West");
        this.searchField = new JTextField();
        this.searchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (Manager.this.searchField.getText() == null) {
                    return;
                }
                if (Manager.this.search.equals(Manager.this.searchField.getText())) {
                    return;
                }
                Manager.this.search = Manager.this.searchField.getText();
                Manager.this.reload();
            }
        });
        this.searchField.addActionListener(e -> {
            for (Configuration c : this.configurations) {
                if (!this.matchesSearch(c)) continue;
                this.launch(c, false);
                return;
            }
        });
        header.add((Component)this.searchField, "Center");
        this.frame.add((Component)header, "North");
    }

    public void createMainArea() {
        this.main = new JPanel();
        this.main.setLayout(new BoxLayout(this.main, 1));
        JScrollPane scroll = new JScrollPane(this.main);
        scroll.setPreferredSize(new Dimension(900, 500));
        scroll.setBorder(BorderFactory.createEmptyBorder());
        JPanel scrollPanel = new JPanel();
        scrollPanel.setLayout(new BorderLayout());
        scrollPanel.add((Component)scroll, "Center");
        scrollPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        this.frame.add((Component)scrollPanel, "Center");
    }

    private void detectOperatingSystem() {
        if (System.getProperty("os.name").startsWith("Windows Server")) {
            this.rootDirectory = System.getenv("LOCALAPPDATA") + "/oxaion";
        } else if (System.getProperty("os.name").startsWith("Windows")) {
            this.rootDirectory = System.getenv("APPDATA") + "/oxaion";
        } else if (System.getProperty("os.name").startsWith("Mac OS")) {
            this.rootDirectory = "/Applications/oxaion";
            try {
                Taskbar.getTaskbar().setIconImage(new ImageIcon(this.getClass().getResource("logo-mac.png")).getImage());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.showMessageDialog("Betriebssystem " + System.getProperty("os.name") + " wird nicht unterst\u00fctzt.", "Fehler", 0);
            System.exit(-1);
        }
    }

    private void reload() {
        this.configurations.sort(Comparator.comparing(Configuration::getSortName));
        this.main.removeAll();
        for (Configuration c : this.configurations) {
            if (!this.matchesSearch(c) || this.viewLocal != c.isDownloaded()) continue;
            this.main.add(this.createPanel(c));
        }
        if (this.main.getComponentCount() > 0) {
            ((JPanel)this.main.getComponent(this.main.getComponentCount() - 1)).setBorder(null);
        }
        this.main.revalidate();
        this.main.repaint();
    }

    private JPanel createPanel(Configuration c) {
        JPanel p = new JPanel();
        this.setPanelSize(p);
        p.addMouseListener(this.launchOnPressed(c));
        p.setBackground(Color.white);
        GridBagLayout layout = new GridBagLayout();
        p.setLayout(layout);
        JLabel nameLabel = new JLabel(c.getName());
        nameLabel.addMouseListener(this.launchOnPressed(c));
        nameLabel.setFont(nameLabel.getFont().deriveFont(1, nameLabel.getFont().getSize() + 1));
        JTextField hostLabel = new JTextField(this.getHostName(c));
        hostLabel.setEditable(false);
        hostLabel.setBackground(Color.white);
        hostLabel.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 0));
        int column = 0;
        int numberOfRows = 2;
        JButton start = this.newButton(this.startLogo);
        p.add((Component)start, new GridBagConstraints(column++, 0, 1, numberOfRows, 0.0, 0.0, 23, 0, new Insets(8, 5, 1, 1), 0, 0));
        start.addActionListener(e -> this.launch(c, (e.getModifiers() & 8) == 8));
        if (c.getNucleusURL() != null) {
            JButton nucleus = this.newButton(this.nucleusLogo);
            nucleus.addActionListener(e -> {
                try {
                    Desktop.getDesktop().browse(new URI(c.getNucleusURL()));
                }
                catch (IOException | URISyntaxException e1) {
                    this.reportError("Nucleus kann nicht gestartet werden", e1);
                }
            });
            p.add((Component)nucleus, new GridBagConstraints(column++, 0, 1, numberOfRows, 0.0, 0.0, 23, 0, new Insets(8, 3, 1, 1), 0, 0));
        } else {
            p.add((Component)new JLabel(), new GridBagConstraints(column++, 0, 1, numberOfRows, 0.0, 0.0, 23, 0, new Insets(0, WINDOWS ? 43 : 53, 0, 0), 0, 0));
        }
        p.add((Component)nameLabel, new GridBagConstraints(column, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 10, 1, 1), WINDOWS ? 1 : 0, 0));
        p.add((Component)hostLabel, new GridBagConstraints(column++, 1, 1, 1, 0.0, 0.0, 23, 0, new Insets(5, 10, 10, 1), 1, 0));
        JLabel filler = new JLabel();
        p.add((Component)filler, new GridBagConstraints(column++, 0, 1, numberOfRows, 1.0, 1.0, 23, 1, new Insets(0, 0, 0, 0), 0, 0));
        if (!c.isFromServer()) {
            JButton editButton = this.newButton(this.editLogo);
            p.add((Component)editButton, new GridBagConstraints(column++, 0, 1, numberOfRows, 0.0, 0.0, 10, 0, new Insets(0, 5, 1, 1), 0, 0));
            editButton.addActionListener(e -> this.edit.setConfig(c));
        }
        if (c.isDownloaded()) {
            JButton delete = this.newButton(this.deleteLogo);
            delete.addActionListener(e -> this.delete(c));
            p.add((Component)delete, new GridBagConstraints(column, 0, 1, numberOfRows, 0.0, 0.0, 10, 0, new Insets(0, 5, 1, 8), 0, 0));
        }
        p.setBorder(new AbstractBorder(){
            Color color = Color.lightGray;

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                g.setColor(this.color);
                g.drawLine(10, height - 1, width - 10, height - 1);
            }
        });
        return p;
    }

    public void setPanelSize(JPanel p) {
        if (this.frame.getWidth() > 0) {
            p.setMaximumSize(new Dimension(this.frame.getWidth() - 10, 60));
        }
    }

    public JButton newButton(ImageIcon logo) {
        JButton start = new JButton(logo);
        start.setCursor(Cursor.getPredefinedCursor(12));
        if (WINDOWS) {
            start.setBackground(Color.white);
            start.setPreferredSize(new Dimension(40, 40));
            start.setMaximumSize(new Dimension(40, 40));
            start.setMinimumSize(new Dimension(40, 40));
        }
        return start;
    }

    private String getHostName(Configuration c) {
        if (this.isLocal(c.getHost())) {
            return c.getHost();
        }
        if (c.getPort() == 80 || c.getPort() == 443) {
            return c.getProtocol() + "://" + c.getHost() + c.getBasePath();
        }
        return c.getProtocol() + "://" + c.getHost() + ":" + c.getPort() + c.getBasePath();
    }

    private void delete(Configuration c) {
        if (this.showConfirmDialog("Wollen Sie die Umgebung wirklich l\u00f6schen?", "L\u00f6schen", 0, 3) != 0) {
            return;
        }
        long count = this.configurations.stream().filter(s -> s.isDownloaded() && c.getHost().equals(s.getHost()) && c.getPort() == s.getPort() && c.getBasePath().equals(s.getBasePath())).count();
        if (!c.isFromServer()) {
            this.configurations.remove(c);
        } else {
            c.setDownloaded(false);
        }
        this.writeManagerFile();
        this.reload();
        if (count > 1L) {
            return;
        }
        new Thread(() -> {
            try {
                String directory = this.getDirectoryName(c);
                if (new java.io.File(this.rootDirectory, directory).exists()) {
                    Files.walkFileTree(Paths.get(this.rootDirectory, directory), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                            java.io.File f = dir.toFile();
                            Manager.this.setStatusText("L\u00f6sche " + f.toString());
                            f.delete();
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attr) {
                            java.io.File f = file.toFile();
                            Manager.this.setStatusText("L\u00f6sche " + f.toString());
                            f.delete();
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                this.setStatusText("L\u00f6schen erfolgreich");
                this.clearStatusText();
            }
            catch (IOException e) {
                this.reportError("Fehler bei Dateioperation", e);
            }
        }).start();
    }

    public String getDirectoryName(Configuration c) {
        Object directory = c.getHost();
        if (!this.isLocal(c.getHost())) {
            directory = c.getPort() != 80 ? (String)directory + "-" + c.getPort() + "-" : (String)directory + "-";
        }
        directory = (String)directory + (c.getBasePath().length() > 1 ? c.getBasePath().substring(1) : c.getBasePath());
        return directory;
    }

    public MouseAdapter launchOnPressed(final Configuration c) {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    Manager.this.launch(c, (e.getModifiersEx() & 0x200) == 512);
                }
            }
        };
    }

    public boolean matchesSearch(Configuration c) {
        return this.search.equals("") || (c.getName().toLowerCase() + c.getHost().toLowerCase() + c.getPort()).contains(this.search);
    }

    private void launch(final Configuration config, final boolean legacy) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Manager.this.setStatusText("Starte " + config.getName() + " ...");
                try {
                    if (Manager.this.isLocalClient(config.getHost())) {
                        if (System.getProperty("os.name").startsWith("Mac OS")) {
                            java.io.File f = new java.io.File(Manager.this.rootDirectory, config.getHost() + "/bin/Client-Mac.app");
                            Desktop.getDesktop().open(f);
                        } else {
                            java.io.File f = new java.io.File(Manager.this.rootDirectory, config.getHost() + "/bin/Client.exe");
                            Desktop.getDesktop().open(f);
                        }
                    } else if (Manager.this.isLocalAdmin(config.getHost())) {
                        if (System.getProperty("os.name").startsWith("Mac OS")) {
                            java.io.File f = new java.io.File(Manager.this.rootDirectory, config.getHost() + "/bin/Admin-Mac.app");
                            Desktop.getDesktop().open(f);
                        } else {
                            java.io.File f = new java.io.File(Manager.this.rootDirectory, config.getHost() + "/bin/Admin.exe");
                            Desktop.getDesktop().open(f);
                        }
                    } else {
                        if (!config.isDownloaded()) {
                            config.setDownloaded(true);
                            Manager.this.writeManagerFile();
                        }
                        ArrayList<Object> arguments = new ArrayList<Object>();
                        if (!legacy && Manager.this.is2021(config)) {
                            arguments.add("client:hessian-url=" + config.getProtocol() + "://" + config.getHost() + ":" + config.getPort() + config.getBasePath());
                            arguments.add("client:user=com.oxaion.jet.client.meta.user.HessianUser");
                        }
                        if (!config.getArguments().isEmpty()) {
                            arguments.addAll(Arrays.asList(config.getArguments().split(" ")));
                        }
                        new UpdateTask(Manager.this, config, arguments.toArray(new String[0])).run();
                    }
                }
                catch (IOException e) {
                    Manager.this.reportError("Fehler bei Dateioperation", e);
                }
                Manager.this.clearStatusText();
            }
        }).start();
    }

    private boolean is2021(Configuration config) {
        java.io.File lib = new java.io.File(this.rootDirectory + "/" + this.getDirectoryName(config) + "/lib");
        if (!lib.exists()) {
            return false;
        }
        for (String f : lib.list()) {
            if (!f.endsWith(".jar") || !f.startsWith("jet-") || !f.contains("2021")) continue;
            return true;
        }
        return false;
    }

    public boolean isLocal(String name) {
        return this.isLocalAdmin(name) || this.isLocalClient(name);
    }

    public boolean isLocalAdmin(String name) {
        return name.equals("admin50");
    }

    public boolean isLocalClient(String name) {
        return name.equals("client70") || name.equals("client71") || name.equals("client80") || name.equals("client81");
    }

    private void readDirectory() {
        java.io.File parent = new java.io.File(this.rootDirectory);
        if (!parent.exists() || !parent.isDirectory()) {
            return;
        }
        for (java.io.File f : parent.listFiles()) {
            if (f.isFile()) continue;
            Configuration config = new Configuration();
            String name = f.getName();
            int port = 80;
            if (!name.startsWith("erp.dev.oxaion.local")) {
                for (String s : name.split("-")) {
                    if (s.chars().filter(i -> !Character.isDigit(i)).findAny().isPresent()) continue;
                    port = Integer.parseInt(s);
                }
            }
            config.setPort(port);
            String portString = "-" + port + "-";
            int index = name.indexOf(portString);
            if (index < 0) {
                index = name.length();
            }
            String host = name.substring(0, index);
            Object basePath = name.substring(Math.min(name.length(), index + portString.length()));
            if (host.startsWith("erp.dev.oxaion.local-")) {
                basePath = host.substring(21);
                host = "erp.dev.oxaion.local";
            }
            if (!((String)basePath).equals("")) {
                name = basePath;
                basePath = "/" + (String)basePath;
            } else {
                name = host;
                if (name.startsWith("jet.")) {
                    name = name.substring(4);
                }
                name = name.replace(".oxaion.local", "");
                name = name.replace(".nucleus.apteancloud.dev", "");
                name = name.replace(".nucleus.apteancloud.com", "");
            }
            config.setProtocol(config.getPort() == 443 ? "https" : "http");
            config.setBasePath((String)basePath);
            config.setConfigFileName("/client.xml");
            config.setName(name);
            config.setHost(host);
            config.setDownloaded(true);
            Configuration existing = this.findExisting(config, false);
            if (existing != null) {
                existing.setDownloaded(true);
                continue;
            }
            this.addConfiguration(config);
        }
    }

    private Configuration findExisting(Configuration c, boolean compareArguments) {
        for (Configuration s : this.configurations) {
            if (s.getPort() != c.getPort() || !s.getHost().equals(c.getHost()) || !s.getBasePath().equals(c.getBasePath()) || compareArguments && !s.getArguments().equals(c.getArguments())) continue;
            return s;
        }
        return null;
    }

    private void addConfiguration(Configuration c) {
        if (c.getHost().endsWith("nucleus.apteancloud.com") && c.getHost().startsWith("jet.")) {
            c.setNucleusUrl(c.getProtocol() + "://" + c.getHost().substring(4));
        }
        if (c.getHost().endsWith("nucleus.apteancloud.dev") && c.getHost().startsWith("jet.")) {
            c.setNucleusUrl(c.getProtocol() + "://" + c.getHost().substring(4));
        }
        if (c.getHost().equals("oxdev01.oxaion.local") && c.getPort() == 11028) {
            c.setNucleusUrl("https://dev.nucleus.apteancloud.dev");
        }
        if (c.getHost().equals("oxdmo02.oxaion.local") && c.getPort() == 11218) {
            c.setNucleusUrl("https://demo.nucleus.apteancloud.com");
        }
        if (c.getHost().equals("oxprod01.oxaion.local") && c.getPort() == 11108) {
            c.setNucleusUrl("https://apteandach.nucleus.apteancloud.com");
        }
        this.configurations.add(c);
    }

    private void readManagerFile() {
        java.io.File xml = new java.io.File(this.rootDirectory, "manager.csv");
        if (!xml.exists()) {
            return;
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(xml));){
            this.readManagerLine(reader, false);
        }
        catch (IOException e) {
            this.reportError("manager.csv konnte nicht gelesen werden", e);
        }
    }

    public void readManagerLine(BufferedReader reader, boolean fromServer) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            String[] elements = line.split("\\|");
            if (line.startsWith("#")) continue;
            Configuration config = new Configuration();
            config.setName(elements[0]);
            config.setHost(elements.length >= 2 ? elements[1] : "");
            config.setPort(elements.length >= 3 ? Integer.parseInt(elements[2]) : 0);
            config.setBasePath(elements.length >= 4 ? elements[3] : "");
            config.setArguments(elements.length >= 5 ? elements[4] : "");
            config.setProtocol(config.getPort() == 443 ? "https" : "http");
            config.setConfigFileName("/client.xml");
            config.setFromServer(fromServer);
            config.setDownloaded(!fromServer);
            Configuration existing = this.findExisting(config, true);
            if (!fromServer && existing != null) {
                existing.setDownloaded(true);
            }
            if (existing != null) continue;
            this.addConfiguration(config);
        }
    }

    private void readManagerUrl() {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new URL("http://webportal.oxaion.local/oxaion-config/manager.csv").openStream()));){
            this.readManagerLine(reader, true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void reportError(String message, Exception e) {
        e.printStackTrace();
        this.showMessageDialog(message + ": " + e.getClass().getSimpleName() + ": " + e.getMessage(), "Fehler", 0);
    }

    private void writeManagerFile() {
        java.io.File xml = new java.io.File(this.rootDirectory, "manager.csv");
        xml.getParentFile().mkdirs();
        try (PrintWriter writer = new PrintWriter(xml);){
            for (Configuration e : this.configurations) {
                if (!e.isDownloaded()) continue;
                writer.print(e.getName());
                writer.print("|");
                writer.print(e.getHost());
                writer.print("|");
                writer.print(e.getPort());
                writer.print("|");
                writer.print(e.getBasePath());
                writer.print("|");
                writer.println(e.getArguments() == null ? "" : e.getArguments());
            }
        }
        catch (IOException e) {
            this.reportError("manager.csv konnte nicht schrieben werden", e);
        }
    }

    @Override
    public void setIndeterminate(boolean b) {
    }

    @Override
    public void setStatusText(String text) {
        SwingUtilities.invokeLater(() -> {
            if (this.progress.getIcon() == null && !"".equals(text)) {
                this.progress.setIcon(this.busyLogo);
                this.frame.setCursor(Cursor.getPredefinedCursor(3));
            }
            if (this.progress.getIcon() != null && "".equals(text)) {
                this.progress.setIcon(null);
                this.frame.setCursor(Cursor.getPredefinedCursor(0));
            }
            this.progress.setText(text);
        });
    }

    public void clearStatusText() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.setStatusText("");
    }

    @Override
    public void setMaximum(long totalDownloadSize) {
    }

    @Override
    public void setToolTipText(String installationPath) {
    }

    @Override
    public void showMessageDialog(String message, String string, int errorMessage) {
        JOptionPane.showMessageDialog(this.frame, message, string, errorMessage);
    }

    @Override
    public int showConfirmDialog(String message, String string, int yesNoOption, int questionMessage) {
        return JOptionPane.showConfirmDialog(this.frame, message, string, yesNoOption, questionMessage);
    }

    @Override
    public long getValue() {
        return this.value;
    }

    @Override
    public void setValue(long progress) {
        this.value = progress;
    }

    @Override
    public void exit(int code) {
    }

    @Override
    public void startDownload(File file) {
        this.setStatusText("Lade " + file.getPath() + " ...");
    }

    private class EditDialog
    extends JDialog {
        private Configuration config;
        private JTextField name;
        private JTextField host;
        private Color white;
        private JTextField arguments;

        public EditDialog() {
            super((Frame)Manager.this.frame, true);
            this.name = new JTextField();
            this.host = new JTextField();
            this.arguments = new JTextField();
            this.white = this.host.getBackground();
            this.setLayout(new BorderLayout());
            JPanel center = new JPanel();
            center.setLayout(new GridBagLayout());
            center.add((Component)new JLabel("Name"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 15, 0, 0), 5, 5));
            center.add((Component)this.name, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 15), 5, 5));
            center.add((Component)new JLabel("Host"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 15, 0, 0), 5, 5));
            center.add((Component)this.host, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 15), 5, 5));
            center.add((Component)new JLabel("Parameter"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 15, 0, 0), 5, 5));
            center.add((Component)this.arguments, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 15), 5, 5));
            JPanel bottom = new JPanel();
            JButton ok = new JButton("OK");
            ok.addActionListener(e -> this.save());
            bottom.add(ok);
            JButton cancel = new JButton("Abbrechen");
            cancel.addActionListener(e -> this.setVisible(false));
            bottom.add(cancel);
            this.add((Component)center, "Center");
            this.add((Component)bottom, "South");
            this.setSize(new Dimension(400, 200));
            this.setLocationRelativeTo(null);
        }

        public void newConfig() {
            this.config = null;
            this.setTitle("Neu");
            this.name.setText("");
            this.host.setText("");
            this.arguments.setText("");
            this.host.setEditable(true);
            this.host.setBackground(this.white);
            this.name.requestFocusInWindow();
            this.setVisible(true);
        }

        public void setConfig(Configuration c) {
            this.config = c;
            this.setTitle("Bearbeiten");
            this.arguments.setText(c.getArguments());
            this.name.setText(c.getName());
            this.host.setText(Manager.this.getHostName(c));
            this.host.setEditable(false);
            this.host.setBackground(Color.lightGray);
            this.name.requestFocusInWindow();
            this.setVisible(true);
        }

        public void save() {
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (this.config == null) {
                try {
                    Object url = this.host.getText();
                    if (((String)url).endsWith("/")) {
                        url = ((String)url).substring(0, ((String)url).length() - 1);
                    }
                    if (!((String)url).endsWith("/client.xml")) {
                        url = (String)url + "/client.xml";
                    }
                    new URL((String)url).openConnection().connect();
                    this.config = Main.configureBaseConfiguration(new URL((String)url));
                }
                catch (IOException e) {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    Manager.this.showMessageDialog("Umgebung nicht gefunden: " + e.getMessage(), "Fehler", 0);
                    return;
                }
            }
            this.config.setDownloaded(true);
            if (this.name.getText().isEmpty()) {
                this.name.setText(this.config.getBasePath().equals("") ? this.config.getHost() : this.config.getBasePath().substring(1));
            }
            this.config.setName(this.name.getText());
            this.config.setArguments(this.arguments.getText());
            if (!Manager.this.configurations.contains(this.config)) {
                Configuration c = Manager.this.findExisting(this.config, true);
                if (c != null) {
                    c.setName(this.config.getName());
                    c.setDownloaded(true);
                } else {
                    Manager.this.addConfiguration(this.config);
                }
            }
            Manager.this.writeManagerFile();
            Manager.this.reload();
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.setVisible(false);
        }
    }

    class ImageRenderer
    extends DefaultTableCellRenderer {
        JLabel lbl = new JLabel();
        ImageIcon icon = new ImageIcon(this.getClass().getResource("logo-opn.png"));

        ImageRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.lbl.setIcon(this.icon);
            return this.lbl;
        }
    }
}

